/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.core.CorePlugin;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.build.BuildContext;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexBuildParticipant
extends RequiredBuildParticipant {
    private Index fIndex;
    private boolean index_trace_enabled = false;
    private boolean advanced_trace_enabled = false;

    @Override
    public void clean(IProject project, IProgressMonitor monitor) {
        BuildPathManager pathManager;
        Set<IBuildPathEntry> entries;
        IndexManager im = this.getIndexManager();
        URI uri = this.getURI(project);
        if (uri != null) {
            if (IndexBuildParticipant.isTraceEnabled()) {
                IndexBuildParticipant.logTrace(MessageFormat.format("Cleaning index for project ''{0}'' ({1})", project.getName(), uri));
            }
            im.resetIndex(uri);
        }
        if (!CollectionsUtil.isEmpty(entries = (pathManager = BuildPathManager.getInstance()).getBuildPaths(project))) {
            for (IBuildPathEntry entry : entries) {
                URI path = entry.getPath();
                if (path == null) continue;
                im.resetIndex(path);
            }
        }
        this.index_trace_enabled = IdeLog.isTraceEnabled((Plugin)BuildPathCorePlugin.getDefault(), (String)"com.aptana.core/debug/builder/indexer");
        this.advanced_trace_enabled = IdeLog.isTraceEnabled((Plugin)BuildPathCorePlugin.getDefault(), (String)"com.aptana.core/debug/builder/advanced");
    }

    @Override
    public void buildStarting(IProject project, int kind, IProgressMonitor monitor) {
        this.fIndex = this.getIndex(project);
    }

    @Override
    public void buildEnding(IProgressMonitor monitor) {
        if (this.fIndex != null) {
            try {
                this.fIndex.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
            this.fIndex = null;
        }
    }

    @Override
    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        block15: {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (this.fIndex == null) {
                    this.fIndex = this.getIndex(context.getProject());
                    if (this.fIndex == null) {
                        return;
                    }
                }
                if (sub.isCanceled()) {
                    return;
                }
                this.deleteFile(context, (IProgressMonitor)sub.newChild(10));
                List<IFileStoreIndexingParticipant> indexers = this.getIndexParticipants(context);
                if (!CollectionsUtil.isEmpty(indexers)) {
                    int workPerIndexer = 90 / indexers.size();
                    for (IFileStoreIndexingParticipant indexer : indexers) {
                        try {
                            long startTime = 0L;
                            if (this.index_trace_enabled) {
                                startTime = System.nanoTime();
                            }
                            indexer.index(context, this.fIndex, (IProgressMonitor)sub.newChild(workPerIndexer));
                            if (this.index_trace_enabled) {
                                double endTime = ((double)System.nanoTime() - (double)startTime) / 1000000.0;
                                IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Indexed file ''{0}'' via ''{1}'' in {2} ms.", context.getURI(), indexer.getClass().getName(), endTime), (String)"com.aptana.core/debug/builder/indexer");
                            }
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Failed to index file {0} with indexer {1}", context.getURI(), indexer.getClass().getName()), (Throwable)e);
                        }
                        if (!sub.isCanceled()) continue;
                        break block15;
                    }
                    break block15;
                }
                if (this.advanced_trace_enabled) {
                    IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("No indexers available for file ''{0}''", context.getURI()), (String)"com.aptana.core/debug/builder/advanced");
                }
            }
            finally {
                sub.done();
            }
        }
    }

    @Override
    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (this.fIndex == null) {
            this.fIndex = this.getIndex(context.getProject());
            if (this.fIndex == null) {
                return;
            }
        }
        this.fIndex.remove(context.getURI());
        if (this.advanced_trace_enabled) {
            IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Wiped index for file ''{0}''", context.getURI()), (String)"com.aptana.core/debug/builder/advanced");
        }
    }

    protected URI getURI(IProject project) {
        if (project == null) {
            return null;
        }
        URI uri = project.getLocationURI();
        if (uri != null) {
            return uri;
        }
        IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Project's location URI is null. raw location: {0}, path: {1}", project.getRawLocationURI(), project.getFullPath()));
        return project.getRawLocationURI();
    }

    protected Index getIndex(IProject project) {
        if (project == null) {
            return null;
        }
        return this.getIndexManager().getIndex(this.getURI(project));
    }

    protected List<IFileStoreIndexingParticipant> getIndexParticipants(BuildContext context) {
        return this.getIndexManager().getIndexParticipants(context.getName());
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected static void logTrace(String message) {
        IdeLog.logInfo((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (String)"com.aptana.core/debug/builder");
    }

    protected static boolean isTraceEnabled() {
        return IdeLog.isTraceEnabled((Plugin)CorePlugin.getDefault(), (String)"com.aptana.core/debug/builder");
    }
}

